; (*| 12:17 29/07/1990 *)
TITLE	SD

BWUK	EQU	0	;conditional for uk date etc.

PAGE  59,132
;PAGE	 60,78

LF	EQU 0AH
CR	EQU 0DH

XFCB_TYPE	STRUC
XFCB_FLAG	DB	  ?
XFCB_RES	DB	 5 DUP(?)
XFCB_ATTR	DB	  ?
XFCB_TYPE	ENDS

FCB_TYPE	STRUC
FCB_DRIVE	DB	  ?
FCB_FNAME	DB	  8 DUP(?)
FCB_EXT		DB	 3 DUP(?)
FCB_CURBLK	DW	   ?
FCB_RECSZ	DW	  ?
FCB_FILSZ	DD	  ?
FCB_DATE	DW	 ?
FCB_TIME	DW	 ?
FCB_RES		DB	 8 DUP(?)
FCB_CURREC	DB	   ?
FCB_RANREC	DD	   ?
FCB_TYPE	ENDS

DIR_ENTRY_TYPE	STRUC
DE_FNAME	DB	 8 DUP(?)
DE_EXT		DB	3 DUP(?)
DE_ATTR		DB	 ?
DE_RES		DB	10 DUP(?)
DE_TIME		DW	 ?
DE_DATE		DW	 ?
DE_START	DW	 ?
DE_FSIZE	DD	 ?
DIR_ENTRY_TYPE	ENDS


SD_REC		STRUC
SD_PTR		DW	?
SD_NAME 	DB	8 DUP(?)
SD_PERIOD	DB	?
SD_EXT		DB	3 DUP(?)
SD_TIME 	DW	?
SD_DATE 	DW	?
SD_SIZE 	DD	?
SD_REC		ENDS

DOSI_VIDEO	EQU 10H 	; Video services

DOSF_CONOUT	EQU  2		; Console output
DOSF_OUTSTR	EQU 09H		; Output string
DOSF_CONINF	EQU 0CH		; * Flush keyboard buffer and input
DOSF_SRHFI	EQU 11H		; Search for first
DOSF_SRHNX	EQU 12H		; Search for next
DOSF_GETDISK	EQU 19H		; Get default disk
DOSF_SDIOA	EQU 1AH		; Set disk I/O address
DOSF_GFATA128	EQU 1CH		; Get file allocation table addr
DOSF_PARSE	EQU 29H		; Parse file name
DOSF_GDATE	EQU 2AH		; Get date
DOSF_GTIME	EQU 2CH		; Get time
DOSF_DOSVER	EQU 30H
DOSF_FREEDSK	EQU 36H

DOSI_FUNC	EQU 21H		; Perform a function

  
;
;									    
;				      SD					     
;									    
;	 Created:   4-May-84						  
;	 Version:						 	
;	 Passes:    5		     Analysis Options on: HK			       
;									    
;									    
;
  
  
SEG_A		SEGMENT	BYTE PUBLIC
		ASSUME	CS:SEG_A, DS:SEG_A
  
  
		ORG	100h
  
SD		PROC	FAR
  
START:
		JMP	BEGIN
BUFFER_PTR	DW	OFFSET BUFFER
DATA_0105	DB	0, 0
DATA_0107	DW	0
NUM_OF_FILES	DW	0
N_FLAG		DB	0
E_FLAG		DB	0
X_FLAG		DB	0
S_FLAG		DB	0
D_FLAG		DB	0
P_FLAG		DB	0
NUM_OF_LINES	DB	21
STRIKE_MSG	DB	'Strike a key when ready . . . $'

IFDEF	BWUK
TITLE_MSG	DB	'Sorted Directory UK by B.W.  '
		DB	'/AEPXSDN/2.3 DRIVE '
ELSE
TITLE_MSG	DB	'Sorted Directory		   '
		DB	'/AEPXSDN/2.3 DRIVE '
ENDIF

DRIVE_MSG	DB	'@:    Date '
DATE1_MSG	DB	'00/'
DATE2_MSG	DB	'00/'
DATE3_MSG	DB	'00  Time '
TIME1_MSG	DB	'00:'
TIME2_MSG	DB	'00', CR, LF
CR_LF_MSG	DB	CR, LF, '$'
LINE2_MSG	DB	'FILESPEC.EXT  BYTES-  --LAST CHANGE--$'
TAB_8_MSG	DB	'	      $'
FILES_MSG	DB	' File(s)', CR, LF, '$'
EXTEND_FCB	DB	0FFH, 0, 0, 0, 0, 0
EX_FCB_ATTR	DB	0
NORMAL_FCB	DB	0
		DB	11 DUP ('?')
		DB	25 DUP (0)
DTA_BUFFER	DB	42 DUP (0)
FREE_MSG	DB	'*FREE SPACE*'
		DB	0
		DB	0, 0, 0
FREE_SIZE	DW	0
		DW	0

BEGIN:
		PUSH	DS
		XOR	AX,AX			; Zero register
		PUSH	AX
		CALL	CMD_OPTIONS
		CALL	READ_DIR
		CMP	N_FLAG,0		; (=0)
		JE	LOC_023F		; Jump if equal
		CALL	SET_UNSORTED_PTRS
		JMP	SHORT LOC_0242
LOC_023F:
		CALL	SORT_DIR_DATA
LOC_0242:
		CALL	GET_FREE
		CALL	SET_MID_TABLE
		CALL	SHOW_LINE1
		CALL	SHOW_DIR
		CALL	SHOW_NUM_OF_FILES
		RETF				; Return far
  
SD		ENDP
  
;
;				   SUBROUTINE
;
  
CMD_OPTIONS	PROC	NEAR
		MOV	SI,81H
		MOV	DI,OFFSET NORMAL_FCB
		MOV	AL,01111B
		MOV	AH,DOSF_PARSE
		INT	DOSI_FUNC		; DOS Services  ah=function 29h
						;  parse filenam @ds:si FCBes:di
		CMP	BYTE PTR [DI],0
		JNE	LOC_026A		; Jump if not equal
		MOV	AH,DOSF_GETDISK
		INT	DOSI_FUNC		; DOS Services  ah=function 19h
						;  get default drive al  (0=a:)
		INC	AL
		STOSB				; Store al to es:[di]
LOC_026A:
		MOV	SI,80H
		MOV	CH,0
		MOV	CL,[SI]
		JCXZ	LOC_RET_02B3		; Jump if cx=0
  
LOCLOOP_0273:
		INC	SI
		CMP	BYTE PTR [SI],'/'
		JNE	LOC_02AA		; Jump if not equal
		MOV	AL,[SI+1]
		AND	AL,0DFH
		CMP	AL,'A'
		JNE	LOC_0287		; Jump if not equal
		MOV	EX_FCB_ATTR,8		; (=0)
LOC_0287:
		CMP	AL,'E'
		JNE	LOC_028E		; Jump if not equal
		MOV	E_FLAG,AL		; (=0)
LOC_028E:
		CMP	AL,'S'
		JNE	LOC_0295		; Jump if not equal
		MOV	S_FLAG,AL		; (=0)
LOC_0295:
		CMP	AL,'D'
		JNE	LOC_029C		; Jump if not equal
		MOV	D_FLAG,AL		; (=0)
LOC_029C:
		CMP	AL,'X'
		JNE	LOC_02A3		; Jump if not equal
		MOV	X_FLAG,AL		; (=0)
LOC_02A3:
		CMP	AL,'N'
		JNE	LOC_02AA		; Jump if not equal
		MOV	N_FLAG,AL		; (=0)
LOC_02AA:
		CMP	AL,'P'
		JNE	LOC_02B1		; Jump if not equal
		MOV	P_FLAG,AL		; (=0)
LOC_02B1:
		LOOP	LOCLOOP_0273		; Loop if cx > 0
  
  
LOC_RET_02B3:
		RETN
CMD_OPTIONS	ENDP
  
  
;
;				   SUBROUTINE
;
  
READ_DIR	PROC	NEAR
		MOV	DX,OFFSET DTA_BUFFER
		MOV	AH,DOSF_SDIOA
		INT	DOSI_FUNC		; DOS Services  ah=function 1Ah
						;  set DTA to ds:dx
		MOV	DX,OFFSET EXTEND_FCB
		MOV	AH,DOSF_SRHFI
		INT	DOSI_FUNC		; DOS Services  ah=function 11h
						;  find filename, FCB @ ds:dx
LOC_02C2:
		OR	AL,AL			; Zero ?
		JNZ	LOC_RET_02FD		; Jump if not zero
		MOV	BX,BUFFER_PTR		; (=61EH)
		LEA	DI,[BX+2]		; Load effective addr
		MOV	SI,OFFSET DTA_BUFFER+FCB_FNAME+SIZE XFCB_TYPE
		MOV	CX,8
		CLD				; Clear direction
		REP	MOVSB			; Rep when cx >0 Mov [si] to es:[di]
		MOV	BYTE PTR [DI],'.'
		INC	DI
		MOV	CX,3
		REP	MOVSB			; Rep when cx >0 Mov [si] to es:[di]
		MOV	SI,OFFSET DTA_BUFFER+DE_TIME+SIZE XFCB_TYPE+1
		MOVSW				; Mov [si] to es:[di]
		MOVSW				; Mov [si] to es:[di]
		MOV	SI,OFFSET DTA_BUFFER+DE_FSIZE+SIZE XFCB_TYPE+1
		MOVSW				; Mov [si] to es:[di]
		MOVSW				; Mov [si] to es:[di]
		ADD	BX,SIZE SD_REC
		MOV	BUFFER_PTR,BX		; (=61EH)
		INC	NUM_OF_FILES		; (=0)
		MOV	DX,OFFSET EXTEND_FCB
		MOV	AH,DOSF_SRHNX
		INT	DOSI_FUNC		; DOS Services  ah=function 12h
						;  find next filenam, FCB @ds:dx
		JMP	SHORT LOC_02C2
  
LOC_RET_02FD:
		RETN
READ_DIR	ENDP
  
  
;
;				   SUBROUTINE
;
  
SORT_DIR_DATA	PROC	NEAR
		MOV	DI,OFFSET BUFFER
LOC_0301:
		CMP	DI,BUFFER_PTR		; (=61EH)
		JAE	LOC_RET_037A		; Jump if above or =
		MOV	SI,OFFSET DATA_0105
LOC_030A:
		MOV	BX,SI
		MOV	SI,[BX]
		OR	SI,SI			; Zero ?
		JZ	LOC_0371		; Jump if zero
		MOV	AX,SI
		MOV	DX,DI
		XOR	CL,CL			; Zero register
		CMP	CL,S_FLAG		; (=0)
		JNE	SORT_BY_SIZE		; Jump if not equal
		CMP	CL,D_FLAG		; (=0)
		JNE	SORT_BY_DATE		; Jump if not equal
		CMP	CL,X_FLAG		; (=0)
		JNE	SORT_BY_EXT		; Jump if not equal
		LEA	SI,[SI+SD_NAME]		; Load effective addr
		LEA	DI,[DI+SD_NAME]		; Load effective addr
		MOV	CX,12
		JMP	SHORT LOC_0368
SORT_BY_EXT:
		LEA	SI,[SI+SD_EXT]		; Load effective addr
		LEA	DI,[DI+SD_EXT]		; Load effective addr
		MOV	CX,3
		JMP	SHORT LOC_0368
SORT_BY_DATE:
		LEA	SI,[SI+SD_DATE]		; Load effective addr
		LEA	DI,[DI+SD_DATE]		; Load effective addr
		MOV	CX,2
		STD				; Set direction flag
		REPE	CMPSW			; Rep zf=1+cx >0 Cmp [si] to es:[di]
		MOV	DI,DX
		MOV	SI,AX
		JBE	LOC_030A		; Jump if below or =
		JMP	SHORT LOC_0371
SORT_BY_SIZE:
		LEA	SI,[SI+SD_SIZE+2]	; Load effective addr
		LEA	DI,[DI+SD_SIZE+2]	; Load effective addr
		MOV	CX,2
		STD				; Set direction flag
		REPE	CMPSW			; Rep zf=1+cx >0 Cmp [si] to es:[di]
		MOV	DI,DX
		MOV	SI,AX
		JBE	LOC_030A		; Jump if below or =
		JMP	SHORT LOC_0371
LOC_0368:
		CLD				; Clear direction
		REPE	CMPSB			; Rep zf=1+cx >0 Cmp [si] to es:[di]
		MOV	DI,DX
		MOV	SI,AX
		JBE	LOC_030A		; Jump if below or =
LOC_0371:
		MOV	[DI],SI
		MOV	[BX],DI
		ADD	DI,SIZE SD_REC
		JMP	SHORT LOC_0301
  
LOC_RET_037A:
		RETN
SORT_DIR_DATA	ENDP
  
  
;
;				   SUBROUTINE
;
  
SET_UNSORTED_PTRS	PROC	NEAR
		MOV	DI,OFFSET BUFFER
		MOV	WORD PTR DATA_0105,DI	; (=0)
		MOV	CX,NUM_OF_FILES		; (=0)
		DEC	CX
  
LOCLOOP_0387:
		MOV	BX,DI
		ADD	DI,SIZE SD_REC
		MOV	[BX],DI
		LOOP	LOCLOOP_0387		; Loop if cx > 0
  
		MOV	[DI],CX
		RETN
SET_UNSORTED_PTRS	ENDP
  
  
;
;				   SUBROUTINE
;
  
SET_MID_TABLE	PROC	NEAR
		MOV	CX,NUM_OF_FILES		; (=0)
		SAR	CX,1			; Shift w/sign fill
		JZ	LOC_RET_03AC		; Jump if zero
		ADC	CL,0
		MOV	BX,OFFSET DATA_0105
  
LOCLOOP_03A1:
		MOV	BX,[BX]
		LOOP	LOCLOOP_03A1		; Loop if cx > 0
  
		MOV	AX,[BX]
		MOV	DATA_0107,AX		; (=0)
		MOV	[BX],CX
  
LOC_RET_03AC:
		RETN
SET_MID_TABLE	ENDP
  
  
;
;				   SUBROUTINE
;
  
GET_FREE	PROC	NEAR
		MOV	DL,NORMAL_FCB		; (=0)
		PUSH	DS
		MOV	AH,DOSF_DOSVER
		INT	DOSI_FUNC		; DOS Services  ah=function 30h
						;  get DOS version number ax
		CMP	AL,2
		JGE	LOC_03F0		; Jump if > or =
		MOV	AH,DOSF_GFATA128
		INT	DOSI_FUNC		; DOS Services  ah=function 1Ch
						;  get disk info drive dl (1=a:)
		MOV	AH,0
		XCHG	CX,DX
		MUL	DX			; dx:ax = reg * ax
		PUSH	AX
		XOR	AX,AX			; Zero register
		MOV	SI,2
  
LOCLOOP_03CA:
		MOV	DI,SI
		SHR	DI,1			; Shift w/zeros fill
		ADD	DI,SI
		MOV	DI,[BX+DI]
		TEST	SI,1
		JZ	LOC_03E0		; Jump if zero
		SHR	DI,1			; Shift w/zeros fill
		SHR	DI,1			; Shift w/zeros fill
		SHR	DI,1			; Shift w/zeros fill
		SHR	DI,1			; Shift w/zeros fill
LOC_03E0:
		AND	DI,0FFFH
		JNZ	LOC_03E7		; Jump if not zero
		INC	AX
LOC_03E7:
		INC	SI
		LOOP	LOCLOOP_03CA		; Loop if cx > 0
  
		POP	CX
		MUL	CX			; dx:ax = reg * ax
		JMP	SHORT LOC_03FA
		NOP
LOC_03F0:
		MOV	AH,DOSF_FREEDSK
		INT	DOSI_FUNC		; DOS Services  ah=function 36h
						;  get free space, drive dl,1=a:
		MUL	BX			; dx:ax = reg * ax
		MOV	DX,AX
		MUL	CX			; dx:ax = reg * ax
LOC_03FA:
		POP	DS
		MOV	FREE_SIZE,AX		; (=0)
		MOV	FREE_SIZE+2,DX		; (=0)
		MOV	BX,WORD PTR DATA_0105	; (=0)
		MOV	DI,OFFSET DTA_BUFFER+40
		MOV	[DI],BX
		MOV	WORD PTR DATA_0105,DI	; (=0)
		INC	NUM_OF_FILES		; (=0)
		RETN
GET_FREE	ENDP
  
  
;
;				   SUBROUTINE
;
  
SHOW_LINE1	PROC	NEAR
		MOV	AL,E_FLAG		; (=0)
		OR	AL,AL			; Zero ?
		JZ	LOC_0442		; Jump if zero
		MOV	AX,300H
		MOV	BH,0
		INT	DOSI_VIDEO		; Video display   ah=functn 03h
						;  get cursor loc in dx, mode cx
		MOV	DL,0
		MOV	AX,200H
		INT	DOSI_VIDEO		; Video display   ah=functn 02h
						;  set cursor location in dx
		MOV	AX,800H
		INT	DOSI_VIDEO		; Video display   ah=functn 08h
						;  get char al & attrib ah @curs
		MOV	BH,AH
		SUB	CX,CX
		MOV	DX,(25-1)* 256 + (80-1)
		MOV	AX,600H
		INT	DOSI_VIDEO		; Video display   ah=functn 06h
						;  scroll up, al=lines
		SUB	DX,DX
		MOV	AH,DOSF_CONOUT
		MOV	BH,0
		INT	DOSI_VIDEO		; Video display   ah=functn 02h
						;  set cursor location in dx
LOC_0442:
		MOV	AL,NORMAL_FCB		; (=0)
		ADD	BYTE PTR DRIVE_MSG,AL	; (=40H)
		MOV	AH,DOSF_GDATE
		INT	DOSI_FUNC		; DOS Services  ah=function 2Ah
						;  get date, cx=year, dx=mon/day
		MOV	AL,DH
		AAM				; Ascii adjust
		XCHG	AL,AH
		OR	WORD PTR DATE1_MSG,AX	; (=3030H)
		MOV	AL,DL
		AAM				; Ascii adjust
		XCHG	AL,AH
		OR	WORD PTR DATE2_MSG,AX	; (=3030H)
		MOV	AX,CX
		SUB	AX,76CH
		AAM				; Ascii adjust
		XCHG	AL,AH
		OR	WORD PTR DATE3_MSG,AX	; (=3030H)
		MOV	AH,DOSF_GTIME
		INT	DOSI_FUNC		; DOS Services  ah=function 2Ch
						;  get time, cx=hrs/min, dh=sec
		MOV	AL,CH
		AAM				; Ascii adjust
		XCHG	AL,AH
		OR	WORD PTR TIME1_MSG,AX	; (=3030H)
		MOV	AL,CL
		AAM				; Ascii adjust
		XCHG	AL,AH
		OR	WORD PTR TIME2_MSG,AX	; (=3030H)
		MOV	DX,OFFSET TITLE_MSG	; (=53H)
		MOV	AH,DOSF_OUTSTR
		INT	DOSI_FUNC		; DOS Services  ah=function 09h
						;  display char string at ds:dx
		MOV	DX,OFFSET LINE2_MSG	; (=46H)
		MOV	AH,DOSF_OUTSTR
		INT	DOSI_FUNC		; DOS Services  ah=function 09h
						;  display char string at ds:dx
		CMP	DATA_0107,0		; (=0)
		JE	LOC_04A9		; Jump if equal
		MOV	DX,OFFSET TAB_8_MSG+3	; (=20H)
		MOV	AH,DOSF_OUTSTR
		INT	DOSI_FUNC		; DOS Services  ah=function 09h
						;  display char string at ds:dx
		MOV	DX,OFFSET LINE2_MSG	; (=46H)
		MOV	AH,DOSF_OUTSTR
		INT	DOSI_FUNC		; DOS Services  ah=function 09h
						;  display char string at ds:dx
LOC_04A9:
		MOV	DX,OFFSET CR_LF_MSG	; (=0DH)
		MOV	AH,DOSF_OUTSTR
		INT	DOSI_FUNC		; DOS Services  ah=function 09h
						;  display char string at ds:dx
		RETN
SHOW_LINE1	ENDP
  
  
;
;				   SUBROUTINE
;
  
SHOW_DIR	PROC	NEAR
LOC_04B1:
		MOV	BX,WORD PTR DATA_0105	; (=0)
		OR	BX,BX			; Zero ?
		JZ	LOC_RET_0507		; Jump if zero
		MOV	AX,[BX]
		MOV	WORD PTR DATA_0105,AX	; (=0)
		CALL	SHOW_ONE_ENTRY
		MOV	BX,DATA_0107		; (=0)
		OR	BX,BX			; Zero ?
		JZ	LOC_04D8		; Jump if zero
		MOV	DX,OFFSET TAB_8_MSG+3	; (=20H)
		MOV	AH,DOSF_OUTSTR
		INT	DOSI_FUNC		; DOS Services  ah=function 09h
						;  display char string at ds:dx
		MOV	AX,[BX]
		MOV	DATA_0107,AX		; (=0)
		CALL	SHOW_ONE_ENTRY
LOC_04D8:
		MOV	DX,OFFSET CR_LF_MSG	; (=0DH)
		MOV	AH,DOSF_OUTSTR
		INT	DOSI_FUNC		; DOS Services  ah=function 09h
						;  display char string at ds:dx
		CMP	P_FLAG,0		; (=0)
		JNE	LOC_04B1		; Jump if not equal
		DEC	NUM_OF_LINES		; (=15H)
		JNZ	LOC_04B1		; Jump if not zero
		MOV	NUM_OF_LINES,23		; (=15H)
		MOV	DX,OFFSET STRIKE_MSG	; (=53H)
		MOV	AH,DOSF_OUTSTR
		INT	DOSI_FUNC		; DOS Services  ah=function 09h
						;  display char string at ds:dx
		MOV	AL,8
		MOV	AH,DOSF_CONINF
		INT	DOSI_FUNC		; DOS Services  ah=function 0Ch
						;  clear keybd buffer & input al
		MOV	DX,OFFSET CR_LF_MSG	; (=0DH)
		MOV	AH,DOSF_OUTSTR
		INT	DOSI_FUNC		; DOS Services  ah=function 09h
						;  display char string at ds:dx
		JMP	SHORT LOC_04B1
  
LOC_RET_0507:
		RETN
SHOW_DIR	ENDP
  
  
;
;				   SUBROUTINE
;
  
SHOW_ONE_ENTRY	PROC	NEAR
		MOV	CX,12
		SUB	DI,DI
  
LOCLOOP_050D:
		MOV	DL,[BX+DI+SD_NAME]
		MOV	AH,DOSF_CONOUT
		INT	DOSI_FUNC		; DOS Services  ah=function 02h
						;  display char dl
		INC	DI
		LOOP	LOCLOOP_050D		; Loop if cx > 0
  
		PUSH	BX
		MOV	SI,WORD PTR [BX+SD_SIZE]
		MOV	DI,WORD PTR [BX+SD_SIZE+2]
		CALL	SHOW_DECIMAL
		POP	BX
		MOV	DX,OFFSET TAB_8_MSG+6	; (=20H)
		MOV	AH,DOSF_OUTSTR
		INT	DOSI_FUNC		; DOS Services  ah=function 09h
						;  display char string at ds:dx
		MOV	AX,[BX+SD_DATE]
		CALL	SHOW_DATE
		MOV	DX,OFFSET TAB_8_MSG+6	; (=20H)
		MOV	AH,DOSF_OUTSTR
		INT	DOSI_FUNC		; DOS Services  ah=function 09h
						;  display char string at ds:dx
		MOV	AX,[BX+SD_TIME]
		CALL	SHOW_TIME
		RETN
SHOW_ONE_ENTRY	ENDP
  
  
;
;				   SUBROUTINE
;
  
SHOW_DECIMAL	PROC	NEAR
		XOR	AX,AX			; Zero register
		MOV	BX,AX
		MOV	BP,AX
		MOV	CX,32
  
LOCLOOP_0546:
		SHL	SI,1			; Shift w/zeros fill
		RCL	DI,1			; Rotate thru carry
		XCHG	AX,BP
		CALL	SUB_058D
		XCHG	AX,BP
		XCHG	AX,BX
		CALL	SUB_058D
		XCHG	AX,BX
		ADC	AL,0
		LOOP	LOCLOOP_0546		; Loop if cx > 0
  
		MOV	CX,1710H
		MOV	AX,BX
		CALL	SUB_0562
		MOV	AX,BP
  
; External Entry into Subroutine 
  
SUB_0562:
		PUSH	AX
		MOV	DL,AH
		CALL	SUB_0569
		POP	DX
  
; External Entry into Subroutine 
  
SUB_0569:
		MOV	DH,DL
		SHR	DL,1			; Shift w/zeros fill
		SHR	DL,1			; Shift w/zeros fill
		SHR	DL,1			; Shift w/zeros fill
		SHR	DL,1			; Shift w/zeros fill
		CALL	SUB_0578
		MOV	DL,DH
  
; External Entry into Subroutine 
  
SUB_0578:
		AND	DL,0FH
		JZ	LOC_057F		; Jump if zero
		MOV	CL,0
LOC_057F:
		DEC	CH
		AND	CL,CH
		OR	DL,'0'
		SUB	DL,CL
		MOV	AH,DOSF_CONOUT
		INT	DOSI_FUNC		; DOS Services  ah=function 02h
						;  display char dl
		RETN
SHOW_DECIMAL	ENDP
  
  
;
;				   SUBROUTINE
;
  
SUB_058D	PROC	NEAR
		ADC	AL,AL
		DAA				; Decimal adjust
		XCHG	AL,AH
		ADC	AL,AL
		DAA				; Decimal adjust
		XCHG	AL,AH
		RETN
SUB_058D	ENDP
  
  
;
;				   SUBROUTINE
;
  
SHOW_DATE	PROC	NEAR
		OR	AX,AX			; Zero ?
		JNZ	LOC_05A4		; Jump if not zero
		MOV	DX,OFFSET TAB_8_MSG	; (=20H)
		MOV	AH,DOSF_OUTSTR
		INT	DOSI_FUNC		; DOS Services  ah=function 09h
						;  display char string at ds:dx
		RETN
LOC_05A4:
		PUSH	AX
IFDEF BWUK
		AND	AX,1FH
ELSE
		AND	AX,1E0H
		MOV	CL,5
		SHR	AX,CL			; Shift w/zeros fill
ENDIF
		CALL	SHOW_DEC99
		MOV	DL,'/'
		MOV	AH,DOSF_CONOUT
		INT	DOSI_FUNC		; DOS Services  ah=function 02h
						;  display char dl
		POP	AX
		PUSH	AX
IFDEF BWUK
		AND	AX,1E0H
		MOV	CL,5
		SHR	AX,CL			; Shift w/zeros fill
ELSE
		AND	AX,1FH
ENDIF
		CALL	SHOW_DEC99
		MOV	DL,'/'
		MOV	AH,DOSF_CONOUT
		INT	DOSI_FUNC		; DOS Services  ah=function 02h
						;  display char dl
		POP	AX
		AND	AX,0FE00H
		MOV	CL,9
		SHR	AX,CL			; Shift w/zeros fill
		ADD	AX,80
SHOW_DATE	ENDP
  
  
;
;				   SUBROUTINE
;
  
SHOW_DEC99	PROC	NEAR
		AAM				; Ascii adjust
		OR	AX,'00'
		PUSH	AX
		MOV	DL,AH
		MOV	AH,DOSF_CONOUT
		INT	DOSI_FUNC		; DOS Services  ah=function 02h
						;  display char dl
		POP	AX
		MOV	DL,AL
		MOV	AH,DOSF_CONOUT
		INT	DOSI_FUNC		; DOS Services  ah=function 02h
						;  display char dl
		RETN
SHOW_DEC99	ENDP
  
  
;
;				   SUBROUTINE
;
  
SHOW_TIME	PROC	NEAR
		OR	AX,AX			; Zero ?
		JNZ	LOC_05EE		; Jump if not zero
		MOV	DX,OFFSET TAB_8_MSG+3	; (=20H)
		MOV	AH,DOSF_OUTSTR
		INT	DOSI_FUNC		; DOS Services  ah=function 09h
						;  display char string at ds:dx
		RETN
LOC_05EE:
		PUSH	AX
		AND	AX,0F800H
		MOV	CL,11
		SHR	AX,CL			; Shift w/zeros fill
		CALL	SHOW_DEC99
		MOV	DL,':'
		MOV	AH,DOSF_CONOUT
		INT	DOSI_FUNC		; DOS Services  ah=function 02h
						;  display char dl
		POP	AX
		AND	AX,7E0H
		MOV	CL,5
		SHR	AX,CL			; Shift w/zeros fill
		CALL	SHOW_DEC99
		RETN
SHOW_TIME	ENDP
  
  
;
;				   SUBROUTINE
;
  
SHOW_NUM_OF_FILES	PROC	NEAR
		MOV	SI,NUM_OF_FILES		; (=0)
		DEC	SI
		XOR	DI,DI			; Zero register
		CALL	SHOW_DECIMAL
		MOV	DX,OFFSET FILES_MSG	; (=20H)
		MOV	AH,DOSF_OUTSTR
		INT	DOSI_FUNC		; DOS Services  ah=function 09h
						;  display char string at ds:dx
		RETN
SHOW_NUM_OF_FILES	ENDP
  
		NOP
BUFFER	DB	10 DUP (0)
		DB	2EH
		DB	215 DUP (0)
		DB	1AH
  
SEG_A		ENDS
  
  
  
		END	START
